#version 330

in vec3 vNormal;
in vec4 vColor;

out vec4 fColor;

uniform mat4 uModelToWorld;
uniform bool uUseModel;

const vec3 directionToLight = normalize(vec3(0.5, 0.3, 0.6));

void main()
{
    vec3 tNormal = vNormal;
    if (uUseModel)
    {
        tNormal = (uModelToWorld * vec4(vNormal, 0.0f)).xyz;
    }

    float clampedCosine;
    if (gl_FrontFacing)
    {
        clampedCosine = clamp(dot(tNormal, directionToLight), 0.2, 1.0);
    }
    else
    {
        clampedCosine = clamp(dot(-tNormal, directionToLight), 0.2, 1.0);
    }
    
    //fColor = vec4(vec3(clampedCosine), 1);
    fColor = vec4(clampedCosine*vColor.rgb, vColor.a);
}